ScriptName RF:ShipTrackerScript Extends ReferenceAlias

RF:FuelHandlerQuest Property FuelManager Auto Mandatory Const
RF:TravelHandlerQuest Property TravelManager Mandatory Const Auto

bool ModRunning = false

; TRAVERSAL

Event OnLocationChange(Location akOldLoc, Location akNewLoc)
    ModRunning = FuelManager.ModRunning()
    bool OKGO = false
    If ModRunning
        If !FuelManager.GetWasJumpIntrasystem(akOldLoc, akNewLoc)
            OKGO = TravelManager.HandleTravelRestriction(akOldLoc, akNewLoc)
        EndIf
        FuelManager.HandleLocChange(akOldLoc, akNewLoc, OKGO)
    EndIf
EndEvent

Event OnShipTakeOff(bool abComplete)
    ModRunning = FuelManager.ModRunning()
    IF ModRunning
        FuelManager.HandleShipTakeOff(abComplete)
    EndIF
EndEvent

Event OnShipGravJump(Location aDestination, int aState)
    IF ModRunning
        TravelManager.HandleGravJump(aDestination, aState)
    EndIf
EndEvent

; SIPHONING

Event OnShipDock(bool abComplete, SpaceshipReference akDocking, SpaceshipReference akParent)
    IF ModRunning
        FuelManager.HandleDocking(abComplete, akDocking, akParent)
    EndIf
EndEvent

Event OnShipUndock(bool abComplete, SpaceshipReference akUndocking, SpaceshipReference akParent)
    IF ModRunning
        FuelManager.HandleUndocking(abComplete, akUndocking, akParent)
    EndIf
EndEvent

; unused

; Event OnShipFarTravel(Location aDepartureLocation, Location aArrivalLocation, int aState)
;     IF ModRunning
;         FuelManager.HandleFarTravel(aDepartureLocation, aArrivalLocation, aState)
;     EndIf
; EndEvent

; Note: This never fired anyways. Using AVMON for release
; Event OnShipRefueled(int aFuelAdded)
;     IF ModRunning
;         FuelManager.HandleRefuel(aFuelAdded)
;     EndIf
; EndEvent